/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.designer;

import filenet.vw.apps.designer.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.FileDialog;
import java.awt.Frame;

public class VWFileContext {
    private static final String DEFAULT_FILE_NAME = VWResource.s_fileSaveFilterNameTemplatePep.toString(VWResource.s_untitled);
    private FileDialog m_saveFileDialog = null;
    private FileDialog m_openFileDialog = null;
    private IVWIDMItem m_idmContextItem = null;

    public VWFileContext(Frame parentFrame) {
        try {
            this.m_openFileDialog = new FileDialog(parentFrame);
            this.m_openFileDialog.setMode(0);
            this.m_openFileDialog.setTitle(VWResource.s_open);
            this.m_openFileDialog.setFile(VWResource.s_fileOpenFilterNamePepXpdl);
            this.m_saveFileDialog = new FileDialog(parentFrame);
            this.m_saveFileDialog.setMode(1);
            this.m_saveFileDialog.setTitle(VWResource.s_save);
            this.m_saveFileDialog.setFile(DEFAULT_FILE_NAME);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public IVWIDMItem getIDMContextItem() {
        return this.m_idmContextItem;
    }

    public void setIDMContextItem(IVWIDMItem idmContextItem) {
        if (idmContextItem != null) {
            this.m_idmContextItem = idmContextItem;
        }
    }

    public FileDialog getOpenFileDialog() {
        return this.m_openFileDialog;
    }

    public FileDialog getSaveFileDialog() {
        return this.m_saveFileDialog;
    }

    protected String getOpenFilePath(String filterString) {
        this.m_openFileDialog.setFile(filterString);
        this.m_openFileDialog.setVisible(true);
        String fileToOpen = this.m_openFileDialog.getFile();
        if (fileToOpen != null) {
            return this.m_openFileDialog.getDirectory() + fileToOpen;
        }
        return null;
    }

    protected void setOpenFilePath(String directory, String fileName) {
        this.m_openFileDialog.setDirectory(directory);
        this.m_openFileDialog.setFile(fileName);
    }

    protected String getSaveFileName() {
        if (this.m_saveFileDialog.getFile() != null) {
            return this.m_saveFileDialog.getFile();
        }
        return VWResource.s_untitled;
    }

    protected String getSaveDirectory() {
        return this.m_saveFileDialog.getDirectory();
    }

    protected String getSaveFilePath(boolean bDisplayUI) {
        if (bDisplayUI) {
            this.m_saveFileDialog.setVisible(true);
            String fileToSave = this.m_saveFileDialog.getFile();
            if (fileToSave != null) {
                return this.m_saveFileDialog.getDirectory() + fileToSave;
            }
            return null;
        }
        return this.m_saveFileDialog.getDirectory() + this.m_saveFileDialog.getFile();
    }

    protected void setSaveFilePath(String directory, String fileName) {
        this.m_saveFileDialog.setDirectory(directory);
        this.m_saveFileDialog.setFile(fileName);
    }

    protected void resetSaveFilePath() {
        this.setSaveFilePath("", DEFAULT_FILE_NAME);
    }

    protected boolean isDefaultSaveFileName() {
        return this.m_saveFileDialog.getFile() == null || VWStringUtils.compare(this.m_saveFileDialog.getFile(), DEFAULT_FILE_NAME) == 0;
    }

    protected void removeReferences() {
        this.m_saveFileDialog = null;
        this.m_openFileDialog = null;
    }
}

